<?PHP 
/**
* Markup to view any message that is not a draft.
* 
* Note that this view is intended to be used within the larger context of inbox/{@link template.php}, in conjunction with the 
* {@link _view_menu} partial.
*
* <code>
* $this->template->set('menu_partial', '_view_menu');
* $this->template->load('template', 'inbox/view', $data); 
* </code>
*
* @package direct-project-innovation-initiative
* @subpackage views
* @filesource
*/ /** */

/*
 A few things to be aware of if we have time to work on this at some point or run into problems in this file:
 	- The way attachments are currently set up, we can't distinguish between a C32 XML file and a different XML file if we have both
	- If we have multiple attached images, we'll have duplicate hidden input fields, which is invalid HTML and may result in unexpected behavior.  
		(ditto if we have an image and a C32 file, etc.).  We may want to double-check that the input fields are necessary.
	- The hidden input fields are being echoed to the screen between <li>s in a <ul>, which is invalid HTML and may result in unexpected behavior. 
																							-- MG 2014-04-30 */
																													
//sent messages include icons to indicate delivery status; let's format them before we display the markup to keep the markup as clear as possible
//this will result in a $to and a $cc address
foreach(array('to', 'cc') as $recipient_type){
	if(!$message->sent){
		$$recipient_type = array_map('htmlentities', $message->addresses_for_display($recipient_type));
	}else{
		$$recipient_type = array();
		foreach($message->addresses_for_display($recipient_type) as $address){	 
			$markup = '<a style="text-decoration:none; color:#000000">' . htmlentities($address) . ' </a>'; //why are we putting the address in an <a>? 
			$markup .= '<img src="/images/email_icons/' . make_string_css_friendly($message->delivery_status($address)) . '.png" title="' . $message->delivery_status($address) . '">';
			array_push($$recipient_type, $markup); //wouldn't normally use array_push, but PHP doesn't seem to like [] with $$ syntax
		}
	}
}

$security_token = $this->security->get_csrf_token_name().'='.$this->security->get_csrf_hash();

?>
<input style="display:none;" id="current_user" value="<?PHP if(isset($status_enabled)){echo $user->id;}?>"/>
<input style="display:none;" id="display_name" value="<?PHP if(isset($status_enabled)){echo $user->cn;}?>"/>
<div id="msg_header">
	<div class="subject" title="<?php echo $message->subject_for_display(); ?>">
		<?php if(isset($status_enabled) && $status_enabled) echo $this->load->view('inbox/_assignment_link', compact('user', 'message', 'workflow_item'), TRUE); ?>
		<?php echo $message->subject_for_display(); ?>
	<?php if($message->importance != 'normal'): ?>
		<br />
		<span class="msg_priority">This message was sent with <?php echo ucfirst($message->importance) ?> importance.</span>
	<?php endif ?>
	</div>
	<div id="msg_subheader">
		<div class="date"><?php echo $message->timestamp_for_display() ?></div>
		<div class="addresses">
			<div class="address-item"><strong>From</strong>: <?php echo implode(', ', array_map('htmlentities', $message->addresses_for_display('sender')))  ?> </div>
				<div class="address-item"><strong>To</strong>: <?php echo implode(', ',  $to) ?></div>
				<?php if(!$message->property_is_empty('cc')): ?>
					<div class="address-item"><strong>CC</strong>: <?php echo implode(', ',  $cc) ?></div>
				<?php endif ?>
		</div>
	<?php if($message->has_attachments()): ?>
		<div class="attachments"> 
			<strong>Attachments</strong>: <br />
			<table id="attachments-list">
			  <tbody>
				<tr>
			<?php $i = 0; ?>
			<?php foreach($message->attachment_files as $attachment): ?>
				<?php if(in_array($attachment->extension, array('jpeg', 'jpg', 'gif', 'png'))): ?>
					<td class="<?php echo $attachment->extension ?>"> 
						<input type="hidden" name="type" value="download/image" />
						<input type="hidden" name="msg_id" value="<?php echo $message->id ?>" />
						<a rel="gallery" title="<?php echo $attachment->name ?>" class="lightbox" href="<?php echo $attachment->url ?>"><?php echo $attachment->name  ?></a>
						(<?php echo byte_format($attachment->bytes)?>)
				<?php elseif($attachment->extension == 'pdf'): ?>
					<td class="<?php echo $attachment->extension ?>"> 
						<a target="_blank" title="<?php echo $attachment->name ?>" href="<?php echo $attachment->url ?>"><?php echo $attachment->name ?></a>
				<?php elseif(!$attachment->property_is_empty('description')): ?>
					<td class="<?php echo $attachment->extension  ?> c32" style="width: 20%;">  
						<input type="hidden" name="type" value="download/pdf" />
						<input type="hidden" name="msg_id" value="<?php echo $message->id ?>" />
						<strong><?php echo $attachment->name ?></strong>
					</td>
					<td class="no" style="width: 50px;">
						<input type="button" title="File Actions for <?php echo $attachment->name ?>" value="Actions" class="btn btn-default btn-xs" data-dropdown="#dropdown-<?php echo $i; ?>"/>
						<div id="dropdown-<?php echo $i; ?>" class="dropdown dropdown-relative dropdown-tip">
							<ul class="dropdown-menu">
								<li><a class="lightbox" title="<?php echo $attachment->name ?>" href="<?php echo $attachment->url. '/?'.$security_token ?>">View</a></li>
								<li><a href="<?php echo '/inbox/message/'.$message->id.'/attachment/'.rawurlencode($attachment->name).'/save_to_das' ?>">Save to DAS <?php if(!$attachment->property_is_empty('das_save_date')): ?>- Last saved on <?php echo $attachment->das_save_date('n/d/Y \a\t g:ia'); ?><?php endif ?></a></li>
								<li><a href="<?php echo $attachment->url .'/download/?'.$security_token ?>">Download</a></li>
								<li><a href="<?php echo $attachment->url .'/download/pdf/?'.$security_token ?>">Download as PDF</a></li>
							</ul>
						</div>
					</td>
					<td class="no">
						<span class="c32name">
							(<?php echo $attachment->description ?>) (<?php echo byte_format($attachment->bytes) ?>)
						</span> 
				<?php else: ?>
					<td class="<?php echo $attachment->extension ?>">
						<a href="<?php echo $attachment->url .'/?'.$security_token ?>"><?php echo  $attachment->name ?></a> (<?php echo byte_format($attachment->bytes)?>)
				<?php endif ?>
					</td>
				</tr>
				<?php $i++; ?>
			<?php endforeach ?>
			</tbody>
			</table>
		</div>
	<?php endif ?>
	</div>
</div>
<div id="msg_body"><?php echo $message->body_for_display ?></div>